import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import numpy as np
import tkinter.filedialog as fd
import numpy.polynomial.polynomial as npp

x = [1.,2.,3.,4.,5.,6.,7.]
y = [10,24,34,54,74,101,133]

root = gc.create_window(title='Polynomial Fit Plot')
control_box, right_frame = gc.create_frames(root)
ax, canvas = pc.create_plot(right_frame)

pc.update_plot(ax, canvas, x, y,
               label_x='y',
               label_y='x',
               marker='o')

coef = npp.polyfit(x, y, 2)
d, e, f, g = 0, 0, 0, 0
a, b, c = coef

#coef = npp.polyfit(x, y, 4)
#d, e, f, g = 0, 0, 0, 0
#a, b, c, d, e = coef

#coef = npp.polyfit(x, y, 6)
#a, b, c, d, e, f, g = coef

gc.create_indicator(control_box, label_1='a_0',
                    label_2=f'{a:.8e}')
gc.create_indicator(control_box, label_1='a_1', 
                    label_2=f'{b:.8e}')
gc.create_indicator(control_box, label_1='a_2', 
                    label_2=f'{c:.8e}')
gc.create_indicator(control_box, label_1='a_3',
                    label_2=f'{d:.8e}')
gc.create_indicator(control_box, label_1='a_4',
                    label_2=f'{e:.8e}')
gc.create_indicator(control_box, label_1='a_5',
                    label_2=f'{f:.8e}')
gc.create_indicator(control_box, label_1='a_6',
                    label_2=f'{g:.8e}')


x =np.linspace(1,7,70)
y_fit = a + b*x + c*x**2 + d*x**3 + e*x**4+ f*x**5 + g*x**6


pc.update_plot(ax, canvas, x, y_fit,
               label_x='x',
               label_y='y',
               clear_flag=False)

